/*
	Name:			XenoN Core Network Component Header
	Version:		1.0
	Update:			2011-02-24
	Copyright:		Copyright  2007-2011 XenoN Core by PsichiX. All rights reserved.
	Author:			PsichiX
	Website:		http://www.xenon.psichix.com
	Description:	XenoN Core Framework Network Component Header
*/

/*
	== EN ==
	This file is part of Xenon Core Framework.
	You may distribute it further, but you can not modify it.
	Please do not use in modified form.
	The principles of XenoN Core License available in the file LICENSE_CORE_EN.TXT or visit: http://www.xenon.psichix.com.

	== PL ==
	Ten plik jest czescia XenoN Core Framework.
	Mozesz go rozpowszechniac dalej, jednak nie mozesz go modyfikowac.
	Nalezy uzytkowac w nie zmodyfikowanej formie.
	Nalezy przestrzegac zasad Licencji XenoN Core dostepnej w pliku LICENSE_CORE_PL.TXT oraz na stronie: http://www.xenon.psichix.com.
*/

#ifndef XE_COMPONENT_NETWORK_H
#define XE_COMPONENT_NETWORK_H

#include "../System/XenonCoreFramework.h"

namespace XeCore
{
//! Przestrzen nazw komponentow
namespace Com
{

class C_PACKET;

#ifdef XE_COMPILE_ETHER

#define C_PACKET_DECLARE_IN(type)	C_PACKET& operator<< (type& d);
#define C_PACKET_DECLARE_OUT(type)	C_PACKET& operator>> (type& d);
#define C_PACKET_DECLARE(type)		C_PACKET_DECLARE_IN(type)C_PACKET_DECLARE_OUT(type)
#define C_PACKET_DEFINE_IN(type)	C_PACKET& C_PACKET::operator<< (type& d){Write(&d,sizeof(type));return(*this);}
#define C_PACKET_DEFINE_OUT(type)	C_PACKET& C_PACKET::operator>> (type& d){Read(&d,sizeof(type));return(*this);}
#define C_PACKET_DEFINE(type)		C_PACKET_DEFINE_IN(type)C_PACKET_DEFINE_OUT(type)

#define C_PACKET_DECLARE_IN_D(type)	C_PACKET& operator<< (type d);
#define C_PACKET_DECLARE_D(type)	C_PACKET_DECLARE_IN_D(type)C_PACKET_DECLARE_OUT(type)
#define C_PACKET_DEFINE_IN_D(type)	C_PACKET& C_PACKET::operator<< (type d){Write(&d,sizeof(type));return(*this);}
#define C_PACKET_DEFINE_D(type)		C_PACKET_DEFINE_IN_D(type)C_PACKET_DEFINE_OUT(type)

//! Klasa pakietu
class C_PACKET : public XE_FILE
{
public:
	C_PACKET& operator<< (XE_SESSION& d);
	C_PACKET& operator>> (XE_SESSION& d);
	C_PACKET& operator<< (XE_STRING& d);
	C_PACKET& operator>> (XE_STRING& d);
	//C_PACKET_DECLARE(XE_SESSION)
	//C_PACKET_DECLARE(XE_STRING)
	C_PACKET_DECLARE_D(XE_CHAR)
	C_PACKET_DECLARE_D(XE_BYTE)
	C_PACKET_DECLARE_D(XE_SHORT)
	C_PACKET_DECLARE_D(XE_WORD)
	C_PACKET_DECLARE_D(XE_INTEGER)
	C_PACKET_DECLARE_D(XE_DWORD)
	C_PACKET_DECLARE_D(XE_HALF)
	C_PACKET_DECLARE_D(XE_REAL)
	C_PACKET_DECLARE(XE_QWORD)
	C_PACKET_DECLARE(XE_VECTOR)
	C_PACKET_DECLARE(XE_HALFVECTOR)
	C_PACKET_DECLARE(XE_ANGLEVECTOR)
	C_PACKET_DECLARE(XE_ANGLEHALFVECTOR)
	C_PACKET_DECLARE(XE_MATRIX)
	C_PACKET_DECLARE(XE_HALFMATRIX)
};

#ifdef XE_CANIMP

C_PACKET& C_PACKET::operator<< (XE_SESSION& d)
{
	XE_FILE b;
	d.Receive(b);
	b.Seek(0);
	Read(b.Data(),b.Size());
	b.Seek(0);
	d.ReceiveEnd(b);
	return(*this);
};

C_PACKET& C_PACKET::operator>> (XE_SESSION& d)
{
	d.Send(*this);
	return(*this);
};

C_PACKET& C_PACKET::operator<< (XE_STRING& d)
{
	WriteString(d.Get(),true);
	return(*this);
};

C_PACKET& C_PACKET::operator>> (XE_STRING& d)
{
	ReadString(d,true);
	return(*this);
};

C_PACKET_DEFINE_D(XE_CHAR)
C_PACKET_DEFINE_D(XE_BYTE)
C_PACKET_DEFINE_D(XE_SHORT)
C_PACKET_DEFINE_D(XE_WORD)
C_PACKET_DEFINE_D(XE_INTEGER)
C_PACKET_DEFINE_D(XE_DWORD)
C_PACKET_DEFINE_D(XE_HALF)
C_PACKET_DEFINE_D(XE_REAL)
C_PACKET_DEFINE(XE_QWORD)
C_PACKET_DEFINE(XE_VECTOR)
C_PACKET_DEFINE(XE_HALFVECTOR)
C_PACKET_DEFINE(XE_ANGLEVECTOR)
C_PACKET_DEFINE(XE_ANGLEHALFVECTOR)
C_PACKET_DEFINE(XE_MATRIX)
C_PACKET_DEFINE(XE_HALFMATRIX)

#endif /* XE_CANIMP */

#endif /* XE_COMPILE_ETHER */

} /* namespace: Com */
} /* namespace: XeCore */

#endif /* XE_COMPONENT_NETWORK_H */
